/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class LDAPDnsToX500DNResponse
extends LDAPExtendedResponse {
    private String namemappedDn;

    public LDAPDnsToX500DNResponse(RfcLDAPMessage rfcLDAPMessage) throws IOException {
        super(rfcLDAPMessage);
        if (this.getID() == null || !this.getID().equals("2.16.840.1.113719.1.27.100.102")) {
            throw new IOException("LDAP Extended Operation not supported");
        }
        if (this.getResultCode() == 0) {
            byte[] byArray = this.getValue();
            if (byArray == null) {
                throw new IOException("LDAP Operations error. No returned value.");
            }
            LBERDecoder lBERDecoder = new LBERDecoder();
            if (lBERDecoder == null) {
                throw new IOException("Decoding error");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)lBERDecoder.decode(byteArrayInputStream);
            if (aSN1OctetString == null) {
                throw new IOException("Decoding error");
            }
            this.namemappedDn = aSN1OctetString.stringValue();
            if (this.namemappedDn == null) {
                throw new IOException("Decoding error");
            }
        } else {
            this.namemappedDn = "";
        }
    }

    public String getX500DN() {
        return this.namemappedDn;
    }
}

