/*
 * Decompiled with CFR 0.152.
 */
package info.skolnik.radovan.hpovsd45.sso;

import com.hp.ifc.rep.views.AppFilterInfo;
import com.hp.ifc.types.AppOID;
import com.hp.ifc.util.AppLog;
import com.hp.ifc.util.marshal.AppAttributeSelection;
import com.hp.ifc.util.marshal.AppWhere;
import com.hp.ifc.wf.AppWorkflowManager;
import com.hp.ifc.wf.IAppEntitySet;
import com.novell.ldap.LDAPAuthHandler;
import com.novell.ldap.LDAPAuthProvider;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPReferralHandler;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import info.skolnik.radovan.hpovsd45.sso.AppFilterInfoWrapper;
import info.skolnik.radovan.hpovsd45.sso.Configuration;
import info.skolnik.radovan.hpovsd45.sso.NonValidatingFactory;
import info.skolnik.radovan.hpovsd45.sso.SSOException;
import info.skolnik.radovan.hpovsd45.sso.ps.IServerHelper;
import java.security.GeneralSecurityException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.SSLSocketFactory;

public class ServerHelper
implements IServerHelper,
LDAPAuthHandler {
    private static LDAPAuthProvider referralAuthenticationProvider;
    protected static AppAttributeSelection aas;

    public Hashtable retrieveCredentialsForNTDomainUser(String string, String string2, String[] stringArray, long l, String string3, String string4, String string5, boolean bl) throws SSOException {
        if (!Configuration.isInitialized() || Configuration.getClientAppFilterInfoWrapper() == null) {
            throw new SSOException(Configuration.SSO_TYPE_NT_DOMAIN + " SSO not configured on server!");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("$NT_DOMAIN$", string);
        hashtable.put("$NT_DOMAIN_SID$", string2);
        StringBuffer stringBuffer = new StringBuffer("{");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i == stringArray.length - 1) continue;
                stringBuffer.append("; ");
            }
        }
        stringBuffer.append("}");
        hashtable.put("$NT_GROUP_IDS$", stringBuffer.toString());
        hashtable.put("$NT_IMPERSONATION_TOKEN$", new Long(l).toString());
        hashtable.put("$NT_NAME$", string3);
        hashtable.put("$NT_PRIMARY_GROUP_ID$", string4);
        hashtable.put("$NT_USER_SID$", string5);
        return this.search(Configuration.getClientAppFilterInfoWrapper(), hashtable, bl || Configuration.getClientDebug());
    }

    public Hashtable retrieveCredentialsForWebApi(String string, Hashtable hashtable, boolean bl) throws SSOException {
        if (!Configuration.isInitialized() || Configuration.getWebApiAppFilterInfoWrapper() == null) {
            throw new SSOException(Configuration.SSO_TYPE_WEB_API + " SSO not configured on server!");
        }
        if (!Configuration.getWebApiSecretKey().equals(string)) {
            AppLog.log((String)"SSO", (String)("Received request for " + Configuration.SSO_TYPE_WEB_API + " SSO with invalid secret key (" + string + ") containing variables: " + this.formatVariablesAsString(hashtable)));
            throw new SSOException(Configuration.SSO_TYPE_WEB_API + " SSO secret key is invalid!");
        }
        return this.search(Configuration.getWebApiAppFilterInfoWrapper(), hashtable, bl || Configuration.getWebApiDebug());
    }

    public LDAPAuthProvider getAuthProvider(String string, int n) {
        if (Configuration.getLDAPDebug()) {
            AppLog.log((String)"SSO", (String)("Returning referral authentication provider for ldap://" + string + ":" + n));
        }
        return referralAuthenticationProvider;
    }

    public Hashtable retrieveCredentialsForLDAPUser(String string, String string2, boolean bl) throws SSOException {
        String string3;
        Object object;
        if (!Configuration.isInitialized() || Configuration.getLDAPAppFilterInfoWrapper() == null) {
            throw new SSOException(Configuration.SSO_TYPE_LDAP + " SSO not configured on server!");
        }
        String string4 = Configuration.getLDAPAppFilterInfoWrapper().getRequestID();
        String string5 = Configuration.decrypt(Configuration.ssoHash, string);
        String string6 = Configuration.decrypt(Configuration.ssoHash, string2);
        LDAPConnection lDAPConnection = new LDAPConnection();
        LDAPSearchConstraints lDAPSearchConstraints = new LDAPSearchConstraints();
        try {
            lDAPConnection.connect(Configuration.getLDAPHost(), Configuration.getLDAPPort());
            lDAPSearchConstraints.setReferralFollowing(Configuration.getLDAPSearchReferralHandling());
            lDAPSearchConstraints.setReferralHandler((LDAPReferralHandler)this);
            lDAPSearchConstraints.setDereference(3);
            lDAPConnection.setConstraints((LDAPConstraints)lDAPSearchConstraints);
        }
        catch (Exception exception) {
            AppLog.log((String)"SSO", (String)("Failed connecting to " + Configuration.getLDAPURL() + " with error: " + exception.getMessage()));
            AppLog.log((Throwable)exception);
            throw new SSOException("Failed connecting to " + Configuration.getLDAPURL() + " with error: " + exception.getMessage());
        }
        if (Configuration.getLDAPSearchFirst()) {
            object = "(" + Configuration.getLDAPUIDAttribute() + "=" + string5 + ")";
            String string7 = Configuration.getLDAPSearchPrincipal();
            String string8 = Configuration.getLDAPSearchCredentials();
            if (string7 != null && string7.length() != 0) {
                if (bl || Configuration.getLDAPDebug()) {
                    AppLog.log((String)"SSO", (String)(string4 + " Binding as \"" + string7 + "\" to " + Configuration.getLDAPURL() + " baseDN=\"" + Configuration.getLDAPBaseDN() + "\" referralHandling=" + Configuration.getLDAPSearchReferralHandling() + " SSL=" + Configuration.getLDAPSSL() + " searching for " + (String)object));
                }
            } else if (bl || Configuration.getLDAPDebug()) {
                AppLog.log((String)"SSO", (String)(string4 + " Anonymous bind to " + Configuration.getLDAPURL() + " baseDN=\"" + Configuration.getLDAPBaseDN() + "\" referralHandling=" + Configuration.getLDAPSearchReferralHandling() + " SSL=" + Configuration.getLDAPSSL() + " searching for " + (String)object));
            }
            try {
                lDAPConnection.bind(3, string7, string8 == null ? null : string8.getBytes("UTF8"), (LDAPConstraints)lDAPSearchConstraints);
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(Configuration.getLDAPBaseDN(), 2, (String)object, null, false, lDAPSearchConstraints);
                LDAPEntry lDAPEntry = null;
                if (lDAPSearchResults != null && lDAPSearchResults.hasMore() && (lDAPEntry = lDAPSearchResults.next()) != null) {
                    if (lDAPSearchResults.hasMore()) {
                        StringBuffer stringBuffer = new StringBuffer("\n\t" + lDAPEntry.getDN());
                        while (lDAPSearchResults.hasMore()) {
                            lDAPEntry = lDAPSearchResults.next();
                            if (lDAPEntry != null) {
                                stringBuffer.append("\n\t" + lDAPEntry.getDN());
                                continue;
                            }
                            stringBuffer.append("\n\t<null entry>");
                        }
                        AppLog.log((String)"SSO", (String)("Multiple results found for \"" + (String)object + "\" request id=" + string4 + stringBuffer.toString()));
                        throw new SSOException("Multiple results found for \"" + (String)object + "\" request id=" + string4);
                    }
                } else {
                    if (bl || Configuration.getLDAPDebug()) {
                        AppLog.log((String)"SSO", (String)("No user found for \"" + (String)object + "\" request id=" + string4));
                    }
                    return null;
                }
                string3 = lDAPEntry.getDN();
            }
            catch (LDAPException lDAPException) {
                AppLog.log((String)"SSO", (String)(string4 + " LDAP search failed with error: " + lDAPException.getMessage()));
                AppLog.log((Throwable)lDAPException);
                throw new SSOException("LDAP search for " + string4 + " failed with error: " + lDAPException.getMessage());
            }
            catch (SSOException sSOException) {
                throw sSOException;
            }
            catch (Exception exception) {
                AppLog.log((String)"SSO", (String)("Unexpected exception occured within LDAP search " + string4 + " request"));
                AppLog.log((Throwable)exception);
                throw new SSOException("Unexpected exception occured within LDAP search " + string4 + " - " + exception.getMessage());
            }
        } else {
            string3 = Configuration.getLDAPUIDAttribute() + "=" + string5 + ", " + Configuration.getLDAPBaseDN();
        }
        try {
            if (bl || Configuration.getLDAPDebug()) {
                AppLog.log((String)"SSO", (String)(string4 + " Binding to " + Configuration.getLDAPURL() + " as principal \"" + string3 + "\"" + " SSL=" + Configuration.getLDAPSSL()));
            }
            lDAPConnection.bind(3, string3, string6.getBytes("UTF8"), (LDAPConstraints)lDAPSearchConstraints);
            lDAPConnection.disconnect();
        }
        catch (LDAPException lDAPException) {
            if (bl || Configuration.getLDAPDebug()) {
                AppLog.log((String)"SSO", (String)("LDAP exception occured while processing " + string4 + " authentication request"));
            }
            if (bl || Configuration.getLDAPDebug()) {
                AppLog.log((Throwable)lDAPException);
            }
            return null;
        }
        catch (Exception exception) {
            AppLog.log((String)"SSO", (String)("Unexpected exception occured while processing " + string4 + " request"));
            AppLog.log((Throwable)exception);
            throw new SSOException("Unexpected server error in " + string4 + " - " + exception.getMessage());
        }
        object = new Hashtable();
        ((Hashtable)object).put(Configuration.LDAP_USERNAME, string5);
        ((Hashtable)object).put(Configuration.LDAP_PRINCIPAL, string3);
        return this.search(string4, Configuration.getLDAPAppFilterInfoWrapper(), (Hashtable)object, bl || Configuration.getLDAPDebug());
    }

    public Hashtable search(AppFilterInfoWrapper appFilterInfoWrapper, Hashtable hashtable, boolean bl) throws SSOException {
        return this.search(appFilterInfoWrapper.getRequestID(), appFilterInfoWrapper, hashtable, bl);
    }

    public Hashtable search(String string, AppFilterInfoWrapper appFilterInfoWrapper, Hashtable hashtable, boolean bl) throws SSOException {
        AppOID[] appOIDArray;
        IAppEntitySet iAppEntitySet;
        Object object;
        Object object2;
        Object object3;
        if (Configuration.demoExpired()) {
            throw new SSOException("Demo limit reached - please consider obtaining license (restart ServiceDesk server to start another demo)");
        }
        try {
            object3 = appFilterInfoWrapper.replaceVariables(hashtable);
            if (bl) {
                AppLog.log((String)"SSO", (String)("Processing request " + string + " containing variables " + this.formatVariablesAsString(hashtable) + " resulting into search query\n" + appFilterInfoWrapper.toString((AppFilterInfo)object3)));
            }
            object2 = AppWorkflowManager.getSystemSession().getEntityHome(object3.getEntityInfo().getID());
            object = object3.getWhere(AppWorkflowManager.getSystemSession());
            iAppEntitySet = object2.find(ServerHelper.getAttributeSelection(), (AppWhere)object);
            appOIDArray = iAppEntitySet.getIdList();
        }
        catch (Exception exception) {
            AppLog.log((String)"SSO", (String)("Unexpected exception occured while processing " + string + " request"));
            AppLog.log((Throwable)exception);
            throw new SSOException("Unexpected server error occured in " + string + " - " + exception.getMessage());
        }
        if (appOIDArray == null || appOIDArray.length == 0) {
            if (bl) {
                AppLog.log((String)"SSO", (String)("No record found for request id=" + string));
            }
            throw new SSOException("No record found for request id=" + string);
        }
        object3 = new StringBuffer();
        if (bl) {
            for (int i = 0; i < appOIDArray.length; ++i) {
                object = this.extractRecordInformation(iAppEntitySet, appOIDArray[i]);
                ((StringBuffer)object3).append("\t[");
                ((StringBuffer)object3).append("(Search code=" + Configuration.decrypt(Configuration.ssoHash, (String)((Hashtable)object).get(new Long(757989495L))) + "), ");
                ((StringBuffer)object3).append("(E-mail=" + Configuration.decrypt(Configuration.ssoHash, (String)((Hashtable)object).get(new Long(757989457L))) + "), ");
                ((StringBuffer)object3).append("(Account;Login name=" + Configuration.decrypt(Configuration.ssoHash, (String)((Hashtable)object).get(new Long(2012L))) + "), ");
                ((StringBuffer)object3).append("(Account;Display name=" + Configuration.decrypt(Configuration.ssoHash, (String)((Hashtable)object).get(new Long(71343L))) + "), ");
                ((StringBuffer)object3).append("(Account;Blocked=" + Configuration.decrypt(Configuration.ssoHash, (String)((Hashtable)object).get(new Long(150875L))) + ")");
                ((StringBuffer)object3).append(i == appOIDArray.length - 1 ? "]" : "];\n");
            }
        }
        if (appOIDArray.length > 1) {
            if (bl) {
                AppLog.log((String)"SSO", (String)("" + appOIDArray.length + " records found for request id=" + string + " - refine your " + appFilterInfoWrapper.getName() + " search filter:\n" + ((StringBuffer)object3).toString()));
            }
            throw new SSOException("More than one record found for request id=" + string);
        }
        object2 = this.extractRecordInformation(iAppEntitySet, appOIDArray[0]);
        if (bl) {
            AppLog.log((String)"SSO", (String)("Record found for request id=" + string + "\n" + ((StringBuffer)object3).toString()));
        }
        return object2;
    }

    private Hashtable extractRecordInformation(IAppEntitySet iAppEntitySet, AppOID appOID) {
        Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
        try {
            String string = (String)iAppEntitySet.getAttributeValue(appOID, new AppOID[]{new AppOID(642973697L), new AppOID(2012L)});
            hashtable.put(new Long(2012L), Configuration.encrypt(Configuration.ssoHash, string));
            String string2 = (String)iAppEntitySet.getAttributeValue(appOID, new AppOID[]{new AppOID(642973697L), new AppOID(2013L)});
            hashtable.put(new Long(2013L), Configuration.encrypt(Configuration.ssoHash, Configuration.decrypt(Configuration.protector, string2)));
            String string3 = (String)iAppEntitySet.getAttributeValue(appOID, new AppOID[]{new AppOID(642973697L), new AppOID(71343L)});
            hashtable.put(new Long(71343L), Configuration.encrypt(Configuration.ssoHash, string3));
            String string4 = (String)iAppEntitySet.getAttributeValue(appOID, 757989495L);
            hashtable.put(new Long(757989495L), Configuration.encrypt(Configuration.ssoHash, string4));
            String string5 = (String)iAppEntitySet.getAttributeValue(appOID, 757989457L);
            hashtable.put(new Long(757989457L), Configuration.encrypt(Configuration.ssoHash, string5));
            Boolean bl = (Boolean)iAppEntitySet.getAttributeValue(appOID, new AppOID[]{new AppOID(642973697L), new AppOID(150875L)});
            hashtable.put(new Long(150875L), Configuration.encrypt(Configuration.ssoHash, bl.toString()));
        }
        catch (Exception exception) {
            AppLog.log((String)"SSO", (String)("Exception in extractRecordInformation: " + exception));
            AppLog.log((Throwable)exception);
            return null;
        }
        return hashtable;
    }

    private String formatVariablesAsString(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                stringBuffer.append("(" + string + "=" + string2 + ")");
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append("; ");
            }
            catch (Exception exception) {}
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static AppAttributeSelection getAttributeSelection() {
        if (aas == null) {
            aas = new AppAttributeSelection();
            aas.putValue(757989495L);
            aas.putValue(757989457L);
            aas.putValue(642973697L, new AppAttributeSelection(2012L));
            aas.putValue(642973697L, new AppAttributeSelection(150875L));
            aas.putValue(642973697L, new AppAttributeSelection(2013L));
            aas.putValue(642973697L, new AppAttributeSelection(281478548619265L));
            aas.putValue(642973697L, new AppAttributeSelection(71343L));
        }
        return aas;
    }

    static {
        block5: {
            referralAuthenticationProvider = null;
            try {
                if (AppLog.getLogfile() == null) break block5;
                AppLog.log((String)"SSO", (String)Configuration.VERSION_INFO);
                AppLog.log((String)"SSO", (String)"Starting ServerHelper initialization...");
                Configuration.init();
                if (Configuration.getLDAPSSL()) {
                    try {
                        LDAPConnection.setSocketFactory((LDAPSocketFactory)new LDAPJSSESecureSocketFactory((SSLSocketFactory)new NonValidatingFactory()));
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        AppLog.log((String)"SSO", (String)("ERROR: Failed to initialize SSL socket factory: " + generalSecurityException));
                    }
                }
                referralAuthenticationProvider = Configuration.getLDAPSearchReferralHandling() && Configuration.getLDAPSearchPrincipal() != null && Configuration.getLDAPSearchPrincipal().length() != 0 ? new LDAPAuthProvider(Configuration.getLDAPSearchPrincipal(), Configuration.getLDAPSearchCredentials() != null ? Configuration.getLDAPSearchCredentials().getBytes("UTF8") : new String("").getBytes("UTF8")) : null;
                AppLog.log((String)"SSO", (String)("ServerHelper Succesfully initialized, " + (Configuration.getSerialNumber() == null ? "running in demo mode..." : "registered to " + Configuration.getSerialNumber())));
            }
            catch (Exception exception) {
                AppLog.log((String)"SSO", (String)"ServerHelper initialization failed. SSO will not be available.");
                AppLog.log((Throwable)exception);
            }
        }
        aas = null;
    }
}

