/*
 * Decompiled with CFR 0.152.
 */
package info.skolnik.radovan.hpovsd45.sso;

import HTTPClient.ParseException;
import HTTPClient.URI;
import com.hp.ifc.rep.AppSettings;
import com.hp.ifc.util.AppBase64;
import com.hp.ifc.util.AppCryptor;
import com.hp.ifc.util.AppLog;
import com.hp.ifc.util.AppUtilities;
import com.jclark.xml.sax.Driver;
import info.skolnik.radovan.hpovsd45.sso.AppFilterInfoWrapper;
import info.skolnik.radovan.hpovsd45.sso.SSOException;
import java.io.File;
import java.io.FileReader;
import java.util.Date;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Configuration {
    private static byte MAGIC = (byte)58;
    private static boolean clientDebug = false;
    private static String clientAFQPath;
    private static AppFilterInfoWrapper clientFilterInfo;
    private static boolean ldapDebug;
    private static String ldapAFQPath;
    private static AppFilterInfoWrapper ldapFilterInfo;
    private static String ldapURL;
    private static String ldapHost;
    private static int ldapPort;
    private static String ldapBaseDN;
    private static String ldapUIDAttribute;
    private static boolean ldapSearchFirst;
    private static String ldapSearchPrincipal;
    private static String ldapSearchCredentials;
    private static boolean ldapSearchReferralHandling;
    private static boolean ldapSSL;
    private static boolean webApiDebug;
    private static String webApiAFQPath;
    private static AppFilterInfoWrapper webApiFilterInfo;
    private static String webApiSecretKey;
    private static String serialNumber;
    private static long initTime;
    private static int DEMO_LIMIT;
    private static Driver parser;
    private static String configFileName;
    private static boolean initialized;
    public static String ssoHash;
    protected static String protector;
    protected static String LDAP_USERNAME;
    protected static String LDAP_PRINCIPAL;
    protected static String SSO_TYPE_NT_DOMAIN;
    protected static String SSO_TYPE_LDAP;
    protected static String SSO_TYPE_WEB_API;
    public static String VERSION_INFO;

    protected static void init() throws Exception {
        String string = AppSettings.getRootFolder() + File.separator + configFileName;
        Driver driver = new Driver();
        driver.setDocumentHandler((DocumentHandler)new XMLParser(driver));
        driver.parse(new InputSource(new FileReader(string)));
        AppFilterInfoWrapper.initialize();
        if (clientAFQPath != null && !clientAFQPath.trim().equals("")) {
            try {
                clientFilterInfo = AppFilterInfoWrapper.loadAppFilterInfoWrapper(clientAFQPath, SSO_TYPE_NT_DOMAIN, clientDebug);
                if (clientFilterInfo.getAppFilterInfo().getEntityID().longValue() != 555155484L) {
                    AppLog.log((String)"SSO", (String)("Provided " + SSO_TYPE_NT_DOMAIN + " file is not a Person Advanced Find Query!"));
                    clientFilterInfo = null;
                }
            }
            catch (Exception exception) {
                AppLog.log((String)"SSO", (String)("Failed to load " + SSO_TYPE_NT_DOMAIN + " AFQ:"));
                AppLog.log((Throwable)exception);
                clientFilterInfo = null;
            }
        }
        if (ldapAFQPath != null && !ldapAFQPath.trim().equals("")) {
            try {
                ldapFilterInfo = AppFilterInfoWrapper.loadAppFilterInfoWrapper(ldapAFQPath, SSO_TYPE_LDAP, ldapDebug);
                if (ldapFilterInfo.getAppFilterInfo().getEntityID().longValue() != 555155484L) {
                    AppLog.log((String)"SSO", (String)("Provided " + SSO_TYPE_LDAP + " file is not a Person Advanced Find Query!"));
                    ldapFilterInfo = null;
                }
            }
            catch (Exception exception) {
                AppLog.log((String)"SSO", (String)("Failed to load " + SSO_TYPE_LDAP + " AFQ:"));
                AppLog.log((Throwable)exception);
                ldapFilterInfo = null;
            }
        }
        if (webApiAFQPath != null && !webApiAFQPath.trim().equals("")) {
            try {
                webApiFilterInfo = AppFilterInfoWrapper.loadAppFilterInfoWrapper(webApiAFQPath, SSO_TYPE_WEB_API, webApiDebug);
                if (webApiFilterInfo.getAppFilterInfo().getEntityID().longValue() != 555155484L) {
                    AppLog.log((String)"SSO", (String)("Provided " + SSO_TYPE_WEB_API + " file is not a Person Advanced Find Query!"));
                    webApiFilterInfo = null;
                }
            }
            catch (Exception exception) {
                AppLog.log((String)"SSO", (String)("Failed to load " + SSO_TYPE_WEB_API + " AFQ:"));
                AppLog.log((Throwable)exception);
                webApiFilterInfo = null;
            }
        }
        if (clientFilterInfo == null && webApiFilterInfo == null && ldapFilterInfo == null) {
            throw new SSOException(SSO_TYPE_NT_DOMAIN + ", " + SSO_TYPE_LDAP + ", " + SSO_TYPE_WEB_API + " all failed to load or not configured!");
        }
        initialized = true;
        initTime = new Date().getTime();
    }

    protected static AppFilterInfoWrapper getClientAppFilterInfoWrapper() {
        return clientFilterInfo;
    }

    protected static AppFilterInfoWrapper getLDAPAppFilterInfoWrapper() {
        return ldapFilterInfo;
    }

    protected static AppFilterInfoWrapper getWebApiAppFilterInfoWrapper() {
        return webApiFilterInfo;
    }

    protected static String getWebApiSecretKey() {
        return webApiSecretKey;
    }

    protected static boolean isInitialized() {
        return initialized;
    }

    protected static boolean getClientDebug() {
        return clientDebug;
    }

    protected static String getLDAPURL() {
        return ldapURL;
    }

    protected static String getLDAPHost() {
        return ldapHost;
    }

    protected static int getLDAPPort() {
        return ldapPort;
    }

    protected static String getLDAPBaseDN() {
        return ldapBaseDN;
    }

    protected static String getLDAPUIDAttribute() {
        return ldapUIDAttribute;
    }

    protected static boolean getLDAPSSL() {
        return ldapSSL;
    }

    protected static boolean getLDAPSearchFirst() {
        return ldapSearchFirst;
    }

    protected static String getLDAPSearchPrincipal() {
        return ldapSearchPrincipal;
    }

    protected static String getLDAPSearchCredentials() {
        return ldapSearchCredentials;
    }

    protected static boolean getLDAPSearchReferralHandling() {
        return ldapSearchReferralHandling;
    }

    protected static boolean getLDAPDebug() {
        return ldapDebug;
    }

    protected static boolean getWebApiDebug() {
        return webApiDebug;
    }

    protected static String getSerialNumber() {
        return serialNumber;
    }

    private static String decodeSerial(String string) {
        try {
            byte by = 0;
            byte[] byArray = AppBase64.decode((String)string);
            for (int i = 1; i < byArray.length; ++i) {
                byArray[i] = (byte)(byArray[i] ^ MAGIC);
                by = (byte)(by + byArray[i]);
            }
            if (by != byArray[0]) {
                return null;
            }
            return new String(byArray, 1, byArray.length - 1, "US-ASCII");
        }
        catch (Exception exception) {
            AppLog.log((String)"SSO", (String)"Failed to decode serial number");
            return null;
        }
    }

    protected static boolean demoExpired() {
        if (Configuration.getSerialNumber() != null) {
            return false;
        }
        return new Date().getTime() >= initTime + (long)DEMO_LIMIT;
    }

    public static String decrypt(String string, String string2) {
        return AppUtilities.toString((byte[])AppCryptor.transform((String)string, (byte[])AppBase64.decode((String)string2)));
    }

    public static String encrypt(String string, String string2) {
        return string2 != null ? AppBase64.encode((byte[])AppCryptor.transform((String)string, (byte[])AppUtilities.toByteArray((String)string2.trim()))) : "";
    }

    static {
        ldapDebug = false;
        ldapSearchReferralHandling = true;
        webApiDebug = false;
        DEMO_LIMIT = 3600000;
        configFileName = "sso_settings.xml";
        initialized = false;
        ssoHash = "!Hp0V_sD#45sS0";
        protector = Configuration.decrypt(ssoHash, "oB67Q/sELsQ+0EyD6oEzFhSn+qr8+jTIJdTcxPub");
        LDAP_USERNAME = "$LDAP_USERNAME$";
        LDAP_PRINCIPAL = "$LDAP_PRINCIPAL$";
        SSO_TYPE_NT_DOMAIN = "NT-DOMAIN";
        SSO_TYPE_LDAP = "LDAP";
        SSO_TYPE_WEB_API = "WEB-API";
        VERSION_INFO = "Single Sign On support for HP OpenView ServiceDesk 4.5 by Radovan Skolnik, radovan@skolnik.info, 1.80 [30/09/2013]";
    }

    static class XMLParser
    extends HandlerBase {
        private Driver parser;

        public XMLParser(Driver driver) {
            this.parser = driver;
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, AttributeList attributeList) {
            int n = this.parser.getLineNumber();
            int n2 = this.parser.getColumnNumber();
            if (string.equalsIgnoreCase("SETTINGS")) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string2 = attributeList.getName(i);
                    String string3 = attributeList.getValue(i);
                    if (string2.equalsIgnoreCase("serialNumber")) {
                        serialNumber = Configuration.decodeSerial(string3);
                        continue;
                    }
                    AppLog.log((String)"SSO", (String)("Configuration error: Unknown attribute " + string2 + " in tag " + string + " (starting at line " + n + ", character " + n2 + ")!"));
                }
            } else if (string.equalsIgnoreCase(SSO_TYPE_NT_DOMAIN)) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string4 = attributeList.getName(i);
                    String string5 = attributeList.getValue(i);
                    if (string4.equalsIgnoreCase("afqFile")) {
                        clientAFQPath = string5;
                        continue;
                    }
                    if (string4.equalsIgnoreCase("debug")) {
                        clientDebug = Boolean.valueOf(string5);
                        continue;
                    }
                    AppLog.log((String)"SSO", (String)("Configuration error: Unknown attribute " + string4 + " in tag " + string + " (starting at line " + n + ", character " + n2 + ")!"));
                }
            } else if (string.equalsIgnoreCase(SSO_TYPE_LDAP)) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string6 = attributeList.getName(i);
                    String string7 = attributeList.getValue(i);
                    if (string6.equalsIgnoreCase("afqFile")) {
                        ldapAFQPath = string7;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("debug")) {
                        ldapDebug = Boolean.valueOf(string7);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("SSL")) {
                        ldapSSL = Boolean.valueOf(string7);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("searchFirst")) {
                        ldapSearchFirst = Boolean.valueOf(string7);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("searchPrincipal")) {
                        ldapSearchPrincipal = string7;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("searchCredentials")) {
                        ldapSearchCredentials = string7;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("searchReferralHandling")) {
                        ldapSearchReferralHandling = Boolean.valueOf(string7);
                        continue;
                    }
                    if (string6.equalsIgnoreCase("URL")) {
                        ldapURL = string7;
                        try {
                            URI uRI = new URI(string7);
                            if (uRI == null || !uRI.getScheme().toLowerCase().equalsIgnoreCase("ldap")) {
                                AppLog.log((String)"SSO", (String)("Unrecognized protocol or failed to parse LDAP URL: " + string7));
                                continue;
                            }
                            ldapHost = uRI.getHost();
                            ldapPort = uRI.getPort() == -1 ? URI.defaultPort(uRI.getScheme()) : uRI.getPort();
                        }
                        catch (ParseException parseException) {
                            AppLog.log((String)"SSO", (String)("Failed to parse LDAP URL: " + parseException.getMessage()));
                        }
                        continue;
                    }
                    if (string6.equalsIgnoreCase("baseDN")) {
                        ldapBaseDN = string7;
                        continue;
                    }
                    if (string6.equalsIgnoreCase("UIDAttribute")) {
                        ldapUIDAttribute = string7;
                        continue;
                    }
                    AppLog.log((String)"SSO", (String)("Configuration error: Unknown attribute " + string6 + " in tag " + string + " (starting at line " + n + ", character " + n2 + ")!"));
                }
            } else if (string.equalsIgnoreCase(SSO_TYPE_WEB_API)) {
                for (int i = 0; i < attributeList.getLength(); ++i) {
                    String string8 = attributeList.getName(i);
                    String string9 = attributeList.getValue(i);
                    if (string8.equalsIgnoreCase("afqFile")) {
                        webApiAFQPath = string9;
                        continue;
                    }
                    if (string8.equalsIgnoreCase("debug")) {
                        webApiDebug = Boolean.valueOf(string9);
                        continue;
                    }
                    if (string8.equalsIgnoreCase("secretKey")) {
                        webApiSecretKey = string9;
                        continue;
                    }
                    AppLog.log((String)"SSO", (String)("Configuration error: Unknown attribute " + string8 + " in tag " + string + " (starting at line " + n + ", character " + n2 + ")!"));
                }
            } else {
                AppLog.log((String)"SSO", (String)("Configuration error: Unknown tag " + string + " (starting at line " + n + ", character " + n2 + ")!"));
            }
        }
    }
}

