/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.ParseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;

public class URI {
    public static final boolean ENABLE_BACKWARDS_COMPATIBILITY = true;
    protected static final Hashtable defaultPorts;
    protected static final Hashtable usesGenericSyntax;
    protected static final Hashtable usesSemiGenericSyntax;
    protected static final BitSet alphanumChar;
    protected static final BitSet markChar;
    protected static final BitSet reservedChar;
    protected static final BitSet unreservedChar;
    protected static final BitSet uricChar;
    protected static final BitSet pcharChar;
    protected static final BitSet userinfoChar;
    protected static final BitSet schemeChar;
    protected static final BitSet hostChar;
    protected static final BitSet opaqueChar;
    protected static final BitSet reg_nameChar;
    public static final BitSet resvdSchemeChar;
    public static final BitSet resvdUIChar;
    public static final BitSet resvdHostChar;
    public static final BitSet resvdPathChar;
    public static final BitSet resvdQueryChar;
    public static final BitSet escpdPathChar;
    public static final BitSet escpdQueryChar;
    public static final BitSet escpdFragChar;
    protected static final int OPAQUE = 0;
    protected static final int SEMI_GENERIC = 1;
    protected static final int GENERIC = 2;
    protected int type;
    protected String scheme;
    protected String opaque;
    protected String userinfo;
    protected String host;
    protected int port = -1;
    protected String path;
    protected String query;
    protected String fragment;
    protected URL url = null;
    private int hashCode = -1;
    private static final char[] hex;
    private static final String nl;

    public URI(String string) throws ParseException {
        this((URI)null, string);
    }

    public URI(URI uRI, String string) throws ParseException {
        int n;
        int n2;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        for (n2 = 0; n2 < n3 && Character.isWhitespace(cArray[n2]); ++n2) {
        }
        while (n3 > 0 && Character.isWhitespace(cArray[n3 - 1])) {
            --n3;
        }
        if (!(n2 >= n3 - 3 || cArray[n2 + 3] != ':' || cArray[n2 + 0] != 'u' && cArray[n2 + 0] != 'U' || cArray[n2 + 1] != 'r' && cArray[n2 + 1] != 'R' || cArray[n2 + 2] != 'i' && cArray[n2 + 2] != 'I' && cArray[n2 + 2] != 'l' && cArray[n2 + 2] != 'L')) {
            n2 += 4;
        }
        for (n = n2; n < n3 && cArray[n] != ':' && cArray[n] != '/' && cArray[n] != '?' && cArray[n] != '#'; ++n) {
        }
        if (n < n3 && cArray[n] == ':') {
            this.scheme = string.substring(n2, n).trim().toLowerCase();
            n2 = n + 1;
        }
        String string2 = this.scheme;
        if (this.scheme == null) {
            if (uRI == null) {
                throw new ParseException("No scheme found");
            }
            string2 = uRI.scheme;
        }
        int n4 = URI.usesGenericSyntax(string2) ? 2 : (this.type = URI.usesSemiGenericSyntax(string2) ? 1 : 0);
        if (this.type == 0) {
            if (uRI != null && this.scheme == null) {
                throw new ParseException("Can't resolve relative URI for scheme " + string2);
            }
            this.opaque = URI.escape(string.substring(n2), opaqueChar, true);
            if (this.opaque.length() > 0 && this.opaque.charAt(0) == '/') {
                this.opaque = "%2F" + this.opaque.substring(1);
            }
            return;
        }
        if (n2 + 1 < n3 && cArray[n2] == '/' && cArray[n2 + 1] == '/') {
            for (n = n2 += 2; n < n3 && cArray[n] != '/' && cArray[n] != '?' && cArray[n] != '#'; ++n) {
            }
            this.parse_authority(string.substring(n2, n), string2);
            n2 = n;
        }
        if (this.type == 1) {
            this.path = URI.escape(string.substring(n2), uricChar, true);
            if (this.path.length() > 0 && this.path.charAt(0) != '/') {
                this.path = '/' + this.path;
            }
        } else {
            for (n = n2; n < n3 && cArray[n] != '?' && cArray[n] != '#'; ++n) {
            }
            this.path = URI.escape(string.substring(n2, n), escpdPathChar, true);
            n2 = n;
            if (n2 < n3 && cArray[n2] == '?') {
                for (n = ++n2; n < n3 && cArray[n] != '#'; ++n) {
                }
                this.query = URI.escape(string.substring(n2, n), escpdQueryChar, true);
                n2 = n;
            }
            if (n2 < n3 && cArray[n2] == '#') {
                this.fragment = URI.escape(string.substring(n2 + 1, n3), escpdFragChar, true);
            }
        }
        if (uRI != null) {
            if (this.scheme != null && !this.scheme.equals(uRI.scheme)) {
                return;
            }
            this.scheme = uRI.scheme;
            if (this.host != null) {
                return;
            }
            this.userinfo = uRI.userinfo;
            this.host = uRI.host;
            this.port = uRI.port;
            if (this.type == 1) {
                return;
            }
            if (this.path.length() == 0 && this.query == null) {
                this.path = uRI.path;
                this.query = uRI.query;
                return;
            }
            if (this.path.length() == 0 || this.path.charAt(0) != '/') {
                n = uRI.path != null ? uRI.path.lastIndexOf(47) : -1;
                this.path = n < 0 ? '/' + this.path : uRI.path.substring(0, n + 1) + this.path;
                this.path = URI.canonicalizePath(this.path);
            }
        }
    }

    public static String canonicalizePath(String string) {
        int n = string.length();
        int n2 = string.indexOf("/.");
        if (n2 == -1 || n2 != n - 2 && string.charAt(n2 + 2) != '/' && (string.charAt(n2 + 2) != '.' || n2 != n - 3 && string.charAt(n2 + 3) != '/')) {
            return string;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n3 = 0;
        for (n2 = 1; n2 < n; ++n2) {
            int n4;
            if (cArray[n2] != '.' || cArray[n2 - 1] != '/') continue;
            if (n2 == n - 1) {
                n4 = n2++;
            } else if (cArray[n2 + 1] == '/') {
                n4 = n2 - 1;
                ++n2;
            } else {
                if (cArray[n2 + 1] != '.' || n2 != n - 2 && cArray[n2 + 2] != '/') continue;
                if (n2 < n3 + 2) {
                    n3 = n2 + 2;
                    continue;
                }
                for (n4 = n2 - 2; n4 > n3 && cArray[n4] != '/'; --n4) {
                }
                if (cArray[n4] != '/') continue;
                if (n2 == n - 2) {
                    ++n4;
                }
                n2 += 2;
            }
            System.arraycopy(cArray, n2, cArray, n4, n - n2);
            n -= n2 - n4;
            n2 = n4;
        }
        return new String(cArray, 0, n);
    }

    private void parse_authority(String string, String string2) throws ParseException {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = cArray.length;
        for (n = n2; n < n3 && cArray[n] != '@'; ++n) {
        }
        if (n < n3 && cArray[n] == '@') {
            this.userinfo = URI.escape(string.substring(n2, n), userinfoChar, true);
            n2 = n + 1;
        }
        if ((n = n2) < n3 && cArray[n] == '[') {
            while (n < n3 && cArray[n] != ']') {
                ++n;
            }
            if (n == n3) {
                throw new ParseException("No closing ']' found for opening '[' at position " + n2 + " in authority `" + string + "'");
            }
            this.host = string.substring(n2 + 1, n);
            ++n;
        } else {
            while (n < n3 && cArray[n] != ':') {
                ++n;
            }
            this.host = URI.escape(string.substring(n2, n), uricChar, true);
        }
        n2 = n;
        if (n2 < n3 - 1 && cArray[n2] == ':') {
            int n4;
            try {
                n4 = Integer.parseInt(URI.unescape(string.substring(n2 + 1, n3), null));
                if (n4 < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(string.substring(n2 + 1, n3) + " is an invalid port number");
            }
            this.port = n4 == URI.defaultPort(string2) ? -1 : n4;
        }
    }

    public URI(URL uRL) throws ParseException {
        this((URI)null, uRL.toExternalForm());
    }

    public URI(String string, String string2, String string3) throws ParseException {
        this(string, null, string2, -1, string3, null, null);
    }

    public URI(String string, String string2, int n, String string3) throws ParseException {
        this(string, null, string2, n, string3, null, null);
    }

    public URI(String string, String string2, String string3, int n, String string4, String string5, String string6) throws ParseException {
        if (string == null) {
            throw new ParseException("missing scheme");
        }
        this.scheme = URI.escape(string.trim().toLowerCase(), schemeChar, true);
        if (string2 != null) {
            this.userinfo = URI.escape(string2.trim(), userinfoChar, true);
        }
        if (string3 != null) {
            String string7 = this.host = URI.isIPV6Addr(string3 = string3.trim()) ? string3 : URI.escape(string3, hostChar, true);
        }
        if (n != URI.defaultPort(string)) {
            this.port = n;
        }
        if (string4 != null) {
            this.path = URI.escape(string4.trim(), escpdPathChar, true);
        }
        if (string5 != null) {
            this.query = URI.escape(string5.trim(), escpdQueryChar, true);
        }
        if (string6 != null) {
            this.fragment = URI.escape(string6.trim(), escpdFragChar, true);
        }
        this.type = URI.usesGenericSyntax(string) ? 2 : 1;
    }

    private static final boolean isIPV6Addr(String string) {
        if (string.indexOf(58) < 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c == ':') continue;
            return false;
        }
        return true;
    }

    public URI(String string, String string2) throws ParseException {
        if (string == null) {
            throw new ParseException("missing scheme");
        }
        this.scheme = URI.escape(string.trim().toLowerCase(), schemeChar, true);
        this.opaque = URI.escape(string2, opaqueChar, true);
        this.type = 0;
    }

    public static boolean usesGenericSyntax(String string) {
        return usesGenericSyntax.containsKey(string.trim().toLowerCase());
    }

    public static boolean usesSemiGenericSyntax(String string) {
        return usesSemiGenericSyntax.containsKey(string.trim().toLowerCase());
    }

    public static final int defaultPort(String string) {
        Integer n = (Integer)defaultPorts.get(string.trim().toLowerCase());
        return n != null ? n : 0;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public String getPath() {
        return this.path;
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPathAndQuery() {
        if (this.query == null) {
            return this.path;
        }
        if (this.path == null) {
            return "?" + this.query;
        }
        return this.path + "?" + this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean isGenericURI() {
        return this.type == 2;
    }

    public boolean isSemiGenericURI() {
        return this.type == 1;
    }

    public URL toURL() throws MalformedURLException {
        if (this.url != null) {
            return this.url;
        }
        if (this.opaque != null) {
            this.url = new URL(this.scheme + ":" + this.opaque);
            return this.url;
        }
        String string = this.userinfo != null && this.host != null ? this.userinfo + "@" + this.host : (this.userinfo != null ? this.userinfo + "@" : this.host);
        StringBuffer stringBuffer = new StringBuffer(100);
        this.assemblePath(stringBuffer, true, true, false);
        this.url = new URL(this.scheme, string, this.port, stringBuffer.toString());
        return this.url;
    }

    private final void assemblePath(StringBuffer stringBuffer, boolean bl, boolean bl2, boolean bl3) {
        if ((this.path == null || this.path.length() == 0) && bl) {
            stringBuffer.append('/');
        }
        if (this.path != null) {
            stringBuffer.append(bl3 ? URI.unescapeNoPE(this.path, resvdPathChar) : this.path);
        }
        if (this.query != null) {
            stringBuffer.append('?');
            stringBuffer.append(bl3 ? URI.unescapeNoPE(this.query, resvdQueryChar) : this.query);
        }
        if (this.fragment != null && bl2) {
            stringBuffer.append('#');
            stringBuffer.append(bl3 ? URI.unescapeNoPE(this.fragment, null) : this.fragment);
        }
    }

    private final String stringify(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.scheme != null) {
            stringBuffer.append(bl ? URI.unescapeNoPE(this.scheme, resvdSchemeChar) : this.scheme);
            stringBuffer.append(':');
        }
        if (this.opaque != null) {
            stringBuffer.append(bl ? URI.unescapeNoPE(this.opaque, null) : this.opaque);
            return stringBuffer.toString();
        }
        if (this.userinfo != null || this.host != null || this.port != -1) {
            stringBuffer.append("//");
        }
        if (this.userinfo != null) {
            stringBuffer.append(bl ? URI.unescapeNoPE(this.userinfo, resvdUIChar) : this.userinfo);
            stringBuffer.append('@');
        }
        if (this.host != null) {
            if (this.host.indexOf(58) < 0) {
                stringBuffer.append(bl ? URI.unescapeNoPE(this.host, resvdHostChar) : this.host);
            } else {
                stringBuffer.append('[').append(this.host).append(']');
            }
        }
        if (this.port != -1) {
            stringBuffer.append(':');
            stringBuffer.append(this.port);
        }
        this.assemblePath(stringBuffer, false, true, bl);
        return stringBuffer.toString();
    }

    public String toExternalForm() {
        return this.stringify(false);
    }

    public String toString() {
        return this.stringify(true);
    }

    public boolean equals(Object object) {
        if (object instanceof URI) {
            URI uRI = (URI)object;
            return this.scheme.equals(uRI.scheme) && (this.type == 0 && URI.areEqual(this.opaque, uRI.opaque) || this.type == 1 && URI.areEqual(this.userinfo, uRI.userinfo) && URI.areEqualIC(this.host, uRI.host) && this.port == uRI.port && URI.areEqual(this.path, uRI.path) || this.type == 2 && URI.areEqual(this.userinfo, uRI.userinfo) && URI.areEqualIC(this.host, uRI.host) && this.port == uRI.port && URI.pathsEqual(this.path, uRI.path) && URI.areEqual(this.query, uRI.query) && URI.areEqual(this.fragment, uRI.fragment));
        }
        if (object instanceof URL) {
            URL uRL = (URL)object;
            String string = this.userinfo != null ? this.userinfo + "@" + this.host : this.host;
            String string2 = this.getPathAndQuery();
            return this.scheme.equalsIgnoreCase(uRL.getProtocol()) && (this.type == 0 && this.opaque.equals(uRL.getFile()) || this.type == 1 && URI.areEqualIC(string, uRL.getHost()) && (this.port == uRL.getPort() || uRL.getPort() == URI.defaultPort(this.scheme)) && URI.areEqual(string2, uRL.getFile()) || this.type == 2 && URI.areEqualIC(string, uRL.getHost()) && (this.port == uRL.getPort() || uRL.getPort() == URI.defaultPort(this.scheme)) && URI.pathsEqual(string2, uRL.getFile()) && URI.areEqual(this.fragment, uRL.getRef()));
        }
        return false;
    }

    private static final boolean areEqual(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && (string.equals(string2) || URI.unescapeNoPE(string, null).equals(URI.unescapeNoPE(string2, null)));
    }

    private static final boolean areEqualIC(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && (string.equalsIgnoreCase(string2) || URI.unescapeNoPE(string, null).equalsIgnoreCase(URI.unescapeNoPE(string2, null)));
    }

    private static final boolean pathsEqual(String string, String string2) {
        int n;
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        for (n = 0; n2 < n3 && n < n4; ++n2, ++n) {
            char c;
            int n5 = n2;
            int n6 = n;
            while (n2 < n3 && (c = string.charAt(n2)) != '/' && c != ';') {
                ++n2;
            }
            while (n < n4 && (c = string2.charAt(n)) != '/' && c != ';') {
                ++n;
            }
            if (n2 == n3 && n < n4 || n == n4 && n2 < n3 || n2 < n3 && n < n4 && string.charAt(n2) != string2.charAt(n)) {
                return false;
            }
            if (string.regionMatches(n5, string2, n6, n2 - n5) && n2 - n5 == n - n6 || URI.unescapeNoPE(string.substring(n5, n2), null).equals(URI.unescapeNoPE(string2.substring(n6, n), null))) continue;
            return false;
        }
        return n2 == n3 && n == n4;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = (this.scheme != null ? URI.unescapeNoPE(this.scheme, null).hashCode() : 0) + (this.type == 0 ? (this.opaque != null ? URI.unescapeNoPE(this.opaque, null).hashCode() : 0) * 7 : (this.host != null ? URI.unescapeNoPE(this.host, null).toLowerCase().hashCode() : 0) * 7 + (this.path != null ? URI.unescapeNoPE(this.path, null).hashCode() : 0) * 13 + (this.query != null ? URI.unescapeNoPE(this.query, null).hashCode() : 0) * 17);
        }
        return this.hashCode;
    }

    public static String escape(String string, BitSet bitSet, boolean bl) {
        return new String(URI.escape(string.toCharArray(), bitSet, bl));
    }

    public static char[] escape(char[] cArray, BitSet bitSet, boolean bl) {
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (bitSet.get(cArray[i])) continue;
            n += 2;
            if (!bl) continue;
            if (cArray[i] >= '\u0080') {
                n += 3;
            }
            if (cArray[i] >= '\u0800') {
                n += 3;
            }
            if ((cArray[i] & 0xFC00) != 55296 || i + 1 >= cArray.length || (cArray[i + 1] & 0xFC00) != 56320) continue;
            n -= 6;
        }
        if (n == 0) {
            return cArray;
        }
        char[] cArray2 = new char[cArray.length + n];
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (bitSet.get(c)) {
                cArray2[n2++] = c;
                continue;
            }
            if (bl) {
                if (c <= '\u007f') {
                    n2 = URI.enc(cArray2, n2, c);
                    continue;
                }
                if (c <= '\u07ff') {
                    n2 = URI.enc(cArray2, n2, 0xC0 | c >> 6 & 0x1F);
                    n2 = URI.enc(cArray2, n2, 0x80 | c >> 0 & 0x3F);
                    continue;
                }
                if ((c & 0xFC00) != 55296 || i + 1 >= cArray.length || (cArray[i + 1] & 0xFC00) != 56320) {
                    n2 = URI.enc(cArray2, n2, 0xE0 | c >> 12 & 0xF);
                    n2 = URI.enc(cArray2, n2, 0x80 | c >> 6 & 0x3F);
                    n2 = URI.enc(cArray2, n2, 0x80 | c >> 0 & 0x3F);
                    continue;
                }
                int n3 = (c & 0x3FF) << 10 | cArray[++i] & 0x3FF;
                n2 = URI.enc(cArray2, n2, 0xF0 | (n3 += 65536) >> 18 & 7);
                n2 = URI.enc(cArray2, n2, 0x80 | n3 >> 12 & 0x3F);
                n2 = URI.enc(cArray2, n2, 0x80 | n3 >> 6 & 0x3F);
                n2 = URI.enc(cArray2, n2, 0x80 | n3 >> 0 & 0x3F);
                continue;
            }
            n2 = URI.enc(cArray2, n2, c);
        }
        return cArray2;
    }

    private static final int enc(char[] cArray, int n, int n2) {
        cArray[n++] = 37;
        cArray[n++] = hex[n2 >> 4 & 0xF];
        cArray[n++] = hex[n2 & 0xF];
        return n;
    }

    public static final String unescape(String string, BitSet bitSet) throws ParseException {
        if (string == null || string.indexOf(37) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        char[] cArray3 = new char[4];
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '%') {
                int n4;
                try {
                    if (i + 3 > cArray.length) {
                        throw new NumberFormatException();
                    }
                    n4 = Integer.parseInt(string.substring(i + 1, i + 3), 16);
                    if (n4 < 0) {
                        throw new NumberFormatException();
                    }
                    i += 2;
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = cArray[i];
                }
                if (n2 > 0) {
                    if ((n4 & 0xC0) != 128) {
                        n3 = URI.copyBuf(cArray3, n, n4, cArray2, n3, bitSet, false);
                        n2 = -1;
                        continue;
                    }
                    if (n == n2 - 1) {
                        n4 = (cArray3[0] & 0xE0) == 192 ? (cArray3[0] & 0x1F) << 6 | n4 & 0x3F : ((cArray3[0] & 0xF0) == 224 ? (cArray3[0] & 0xF) << 12 | (cArray3[1] & 0x3F) << 6 | n4 & 0x3F : (cArray3[0] & 7) << 18 | (cArray3[1] & 0x3F) << 12 | (cArray3[2] & 0x3F) << 6 | n4 & 0x3F);
                        if (bitSet != null && bitSet.get(n4)) {
                            n3 = URI.copyBuf(cArray3, n, n4, cArray2, n3, null, true);
                        } else if (n2 < 4) {
                            cArray2[n3++] = (char)n4;
                        } else {
                            cArray2[n3++] = (char)((n4 -= 65536) >> 10 | 0xD800);
                            cArray2[n3++] = (char)(n4 & 0x3FF | 0xDC00);
                        }
                        n2 = -1;
                        continue;
                    }
                    cArray3[n++] = (char)n4;
                    continue;
                }
                if ((n4 & 0xE0) == 192 || (n4 & 0xF0) == 224 || (n4 & 0xF8) == 240) {
                    n2 = (n4 & 0xE0) == 192 ? 2 : ((n4 & 0xF0) == 224 ? 3 : 4);
                    cArray3[0] = (char)n4;
                    n = 1;
                    continue;
                }
                if (bitSet != null && bitSet.get(n4)) {
                    cArray2[n3++] = cArray[i];
                    i -= 2;
                    continue;
                }
                cArray2[n3++] = (char)n4;
                continue;
            }
            if (n2 > 0) {
                n3 = URI.copyBuf(cArray3, n, cArray[i], cArray2, n3, bitSet, false);
                n2 = -1;
                continue;
            }
            cArray2[n3++] = cArray[i];
        }
        if (n2 > 0) {
            n3 = URI.copyBuf(cArray3, n, -1, cArray2, n3, bitSet, false);
        }
        return new String(cArray2, 0, n3);
    }

    private static final int copyBuf(char[] cArray, int n, int n2, char[] cArray2, int n3, BitSet bitSet, boolean bl) {
        if (n2 >= 0) {
            cArray[n++] = (char)n2;
        }
        for (int i = 0; i < n; ++i) {
            if (bitSet != null && bitSet.get(cArray[i]) || bl) {
                n3 = URI.enc(cArray2, n3, cArray[i]);
                continue;
            }
            cArray2[n3++] = cArray[i];
        }
        return n3;
    }

    private static final String unescapeNoPE(String string, BitSet bitSet) {
        try {
            return URI.unescape(string, bitSet);
        }
        catch (ParseException parseException) {
            return string;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.err.println();
        System.err.println("*** URI Tests ...");
        URI uRI = new URI("http://a/b/c/d;p?q");
        URI.testParser(uRI, "g:h", "g:h");
        URI.testParser(uRI, "g", "http://a/b/c/g");
        URI.testParser(uRI, "./g", "http://a/b/c/g");
        URI.testParser(uRI, "g/", "http://a/b/c/g/");
        URI.testParser(uRI, "/g", "http://a/g");
        URI.testParser(uRI, "//g", "http://g");
        URI.testParser(uRI, "//[23:54]", "http://[23:54]");
        URI.testParser(uRI, "?y", "http://a/b/c/?y");
        URI.testParser(uRI, "g?y", "http://a/b/c/g?y");
        URI.testParser(uRI, "#s", "http://a/b/c/d;p?q#s");
        URI.testParser(uRI, "g#s", "http://a/b/c/g#s");
        URI.testParser(uRI, "g?y#s", "http://a/b/c/g?y#s");
        URI.testParser(uRI, ";x", "http://a/b/c/;x");
        URI.testParser(uRI, "g;x", "http://a/b/c/g;x");
        URI.testParser(uRI, "g;x?y#s", "http://a/b/c/g;x?y#s");
        URI.testParser(uRI, ".", "http://a/b/c/");
        URI.testParser(uRI, "./", "http://a/b/c/");
        URI.testParser(uRI, "..", "http://a/b/");
        URI.testParser(uRI, "../", "http://a/b/");
        URI.testParser(uRI, "../g", "http://a/b/g");
        URI.testParser(uRI, "../..", "http://a/");
        URI.testParser(uRI, "../../", "http://a/");
        URI.testParser(uRI, "../../g", "http://a/g");
        URI.testParser(uRI, "", "http://a/b/c/d;p?q");
        URI.testParser(uRI, "/./g", "http://a/./g");
        URI.testParser(uRI, "/../g", "http://a/../g");
        URI.testParser(uRI, "../../../g", "http://a/../g");
        URI.testParser(uRI, "../../../../g", "http://a/../../g");
        URI.testParser(uRI, "g.", "http://a/b/c/g.");
        URI.testParser(uRI, ".g", "http://a/b/c/.g");
        URI.testParser(uRI, "g..", "http://a/b/c/g..");
        URI.testParser(uRI, "..g", "http://a/b/c/..g");
        URI.testParser(uRI, "./../g", "http://a/b/g");
        URI.testParser(uRI, "./g/.", "http://a/b/c/g/");
        URI.testParser(uRI, "g/./h", "http://a/b/c/g/h");
        URI.testParser(uRI, "g/../h", "http://a/b/c/h");
        URI.testParser(uRI, "g;x=1/./y", "http://a/b/c/g;x=1/y");
        URI.testParser(uRI, "g;x=1/../y", "http://a/b/c/y");
        URI.testParser(uRI, "g?y/./x", "http://a/b/c/g?y/./x");
        URI.testParser(uRI, "g?y/../x", "http://a/b/c/g?y/../x");
        URI.testParser(uRI, "g#s/./x", "http://a/b/c/g#s/./x");
        URI.testParser(uRI, "g#s/../x", "http://a/b/c/g#s/../x");
        URI.testParser(uRI, "http:g", "http://a/b/c/g");
        URI.testParser(uRI, "http:", "http://a/b/c/d;p?q");
        URI.testParser(uRI, "./g:h", "http://a/b/c/g:h");
        uRI = new URI("http://a/b/c/d;p?q=1/2");
        URI.testParser(uRI, "g", "http://a/b/c/g");
        URI.testParser(uRI, "./g", "http://a/b/c/g");
        URI.testParser(uRI, "g/", "http://a/b/c/g/");
        URI.testParser(uRI, "/g", "http://a/g");
        URI.testParser(uRI, "//g", "http://g");
        URI.testParser(uRI, "//[23:54]", "http://[23:54]");
        URI.testParser(uRI, "?y", "http://a/b/c/?y");
        URI.testParser(uRI, "g?y", "http://a/b/c/g?y");
        URI.testParser(uRI, "g?y/./x", "http://a/b/c/g?y/./x");
        URI.testParser(uRI, "g?y/../x", "http://a/b/c/g?y/../x");
        URI.testParser(uRI, "g#s", "http://a/b/c/g#s");
        URI.testParser(uRI, "g#s/./x", "http://a/b/c/g#s/./x");
        URI.testParser(uRI, "g#s/../x", "http://a/b/c/g#s/../x");
        URI.testParser(uRI, "./", "http://a/b/c/");
        URI.testParser(uRI, "../", "http://a/b/");
        URI.testParser(uRI, "../g", "http://a/b/g");
        URI.testParser(uRI, "../../", "http://a/");
        URI.testParser(uRI, "../../g", "http://a/g");
        uRI = new URI("http://a/b/c/d;p=1/2?q");
        URI.testParser(uRI, "g", "http://a/b/c/d;p=1/g");
        URI.testParser(uRI, "./g", "http://a/b/c/d;p=1/g");
        URI.testParser(uRI, "g/", "http://a/b/c/d;p=1/g/");
        URI.testParser(uRI, "g?y", "http://a/b/c/d;p=1/g?y");
        URI.testParser(uRI, ";x", "http://a/b/c/d;p=1/;x");
        URI.testParser(uRI, "g;x", "http://a/b/c/d;p=1/g;x");
        URI.testParser(uRI, "g;x=1/./y", "http://a/b/c/d;p=1/g;x=1/y");
        URI.testParser(uRI, "g;x=1/../y", "http://a/b/c/d;p=1/y");
        URI.testParser(uRI, "./", "http://a/b/c/d;p=1/");
        URI.testParser(uRI, "../", "http://a/b/c/");
        URI.testParser(uRI, "../g", "http://a/b/c/g");
        URI.testParser(uRI, "../../", "http://a/b/");
        URI.testParser(uRI, "../../g", "http://a/b/g");
        uRI = new URI("fred:///s//a/b/c");
        URI.testParser(uRI, "g:h", "g:h");
        URI.testPE(uRI, "g");
        uRI = new URI("http:///s//a/b/c");
        URI.testParser(uRI, "g:h", "g:h");
        URI.testParser(uRI, "g", "http:///s//a/b/g");
        URI.testParser(uRI, "./g", "http:///s//a/b/g");
        URI.testParser(uRI, "g/", "http:///s//a/b/g/");
        URI.testParser(uRI, "/g", "http:///g");
        URI.testParser(uRI, "//g", "http://g");
        URI.testParser(uRI, "//[23:54]", "http://[23:54]");
        URI.testParser(uRI, "//g/x", "http://g/x");
        URI.testParser(uRI, "///g", "http:///g");
        URI.testParser(uRI, "./", "http:///s//a/b/");
        URI.testParser(uRI, "../", "http:///s//a/");
        URI.testParser(uRI, "../g", "http:///s//a/g");
        URI.testParser(uRI, "../../", "http:///s//");
        URI.testParser(uRI, "../../g", "http:///s//g");
        URI.testParser(uRI, "../../../g", "http:///s/g");
        URI.testParser(uRI, "../../../../g", "http:///g");
        uRI = new URI("http://s");
        URI.testParser(uRI, "ftp:h", "ftp:h");
        URI.testParser(uRI, "ftp://h", "ftp://h");
        URI.testParser(uRI, "//g", "http://g");
        URI.testParser(uRI, "//g?h", "http://g?h");
        URI.testParser(uRI, "g", "http://s/g");
        URI.testParser(uRI, "./g", "http://s/g");
        URI.testParser(uRI, "?g", "http://s/?g");
        URI.testParser(uRI, "#g", "http://s#g");
        uRI = new URI("http:");
        URI.testParser(uRI, "ftp:h", "ftp:h");
        URI.testParser(uRI, "ftp://h", "ftp://h");
        URI.testParser(uRI, "//g", "http://g");
        URI.testParser(uRI, "g", "http:/g");
        URI.testParser(uRI, "?g", "http:/?g");
        URI.testParser(uRI, "#g", "http:#g");
        uRI = new URI("http://s/t");
        URI.testParser(uRI, "ftp:/h", "ftp:/h");
        URI.testParser(uRI, "http:/h", "http://s/h");
        uRI = new URI("http://s/g?h/j");
        URI.testParser(uRI, "k", "http://s/k");
        URI.testParser(uRI, "k?l", "http://s/k?l");
        uRI = new URI("ldap:");
        URI.testParser(uRI, "ldap:", "ldap:");
        URI.testParser(uRI, "ldap://a", "ldap://a");
        URI.testParser(uRI, "ldap://a/b", "ldap://a/b");
        URI.testParser(uRI, "ldap:/b", "ldap:/b");
        URI.testParser(uRI, "ftp:h", "ftp:h");
        URI.testParser(uRI, "ftp://h", "ftp://h");
        URI.testParser(uRI, "//g", "ldap://g");
        URI.testParser(uRI, "//g?h", "ldap://g/?h");
        URI.testParser(uRI, "g", "ldap:/g");
        URI.testParser(uRI, "./g", "ldap:/./g");
        URI.testParser(uRI, "?g", "ldap:/?g");
        URI.testParser(uRI, "#g", "ldap:/%23g");
        uRI = new URI("ldap://s");
        URI.testParser(uRI, "ldap:", "ldap://s");
        URI.testParser(uRI, "ldap://a", "ldap://a");
        URI.testParser(uRI, "ldap://a/b", "ldap://a/b");
        URI.testParser(uRI, "ldap:/b", "ldap://s/b");
        URI.testParser(uRI, "ftp:h", "ftp:h");
        URI.testParser(uRI, "ftp://h", "ftp://h");
        URI.testParser(uRI, "//g", "ldap://g");
        URI.testParser(uRI, "//g?h", "ldap://g/?h");
        URI.testParser(uRI, "g", "ldap://s/g");
        URI.testParser(uRI, "./g", "ldap://s/./g");
        URI.testParser(uRI, "?g", "ldap://s/?g");
        URI.testParser(uRI, "#g", "ldap://s/%23g");
        uRI = new URI("ldap://s/t");
        URI.testParser(uRI, "ftp:/h", "ftp:/h");
        URI.testParser(uRI, "ldap:/h", "ldap://s/h");
        URI.testParser(uRI, "ldap:", "ldap://s");
        URI.testParser(uRI, "ldap://a", "ldap://a");
        URI.testParser(uRI, "ldap://a/b", "ldap://a/b");
        URI.testParser(uRI, "ftp:h", "ftp:h");
        URI.testParser(uRI, "ftp://h", "ftp://h");
        URI.testParser(uRI, "//g", "ldap://g");
        URI.testParser(uRI, "//g?h", "ldap://g/?h");
        URI.testParser(uRI, "g", "ldap://s/g");
        URI.testParser(uRI, "./g", "ldap://s/./g");
        URI.testParser(uRI, "?g", "ldap://s/?g");
        URI.testParser(uRI, "#g", "ldap://s/%23g");
        URI.testNotEqual("http://a/", "nntp://a/");
        URI.testNotEqual("http://a/", "https://a/");
        URI.testNotEqual("http://a/", "shttp://a/");
        URI.testEqual("http://a/", "Http://a/");
        URI.testEqual("http://a/", "hTTP://a/");
        URI.testEqual("url:http://a/", "hTTP://a/");
        URI.testEqual("urI:http://a/", "hTTP://a/");
        URI.testEqual("http://a/", "Http://A/");
        URI.testEqual("http://a.b.c/", "Http://A.b.C/");
        URI.testEqual("http:///", "Http:///");
        URI.testEqual("http://[]/", "Http:///");
        URI.testNotEqual("http:///", "Http://a/");
        URI.testNotEqual("http://[]/", "Http://a/");
        URI.testPE(null, "ftp://[23::43:1/");
        URI.testPE(null, "ftp://[/");
        URI.testEqual("http://a.b.c/", "Http://A.b.C:80/");
        URI.testEqual("http://a.b.c:/", "Http://A.b.C:80/");
        URI.testEqual("http://[23::45:::5:]/", "Http://[23::45:::5:]:80/");
        URI.testEqual("http://[23::45:::5:]:/", "Http://[23::45:::5:]:80/");
        URI.testEqual("nntp://a", "nntp://a:119");
        URI.testEqual("nntp://a:", "nntp://a:119");
        URI.testEqual("nntp://a/", "nntp://a:119/");
        URI.testNotEqual("nntp://a", "nntp://a:118");
        URI.testNotEqual("nntp://a", "nntp://a:0");
        URI.testNotEqual("nntp://a:", "nntp://a:0");
        URI.testEqual("telnet://:23/", "telnet:///");
        URI.testPE(null, "ftp://:a/");
        URI.testPE(null, "ftp://:-1/");
        URI.testPE(null, "ftp://::1/");
        URI.testNotEqual("ftp://me@a", "ftp://a");
        URI.testNotEqual("ftp://me@a", "ftp://Me@a");
        URI.testEqual("ftp://Me@a", "ftp://Me@a");
        URI.testEqual("ftp://Me:My@a:21", "ftp://Me:My@a");
        URI.testEqual("ftp://Me:My@a:", "ftp://Me:My@a");
        URI.testNotEqual("ftp://Me:My@a:21", "ftp://Me:my@a");
        URI.testNotEqual("ftp://Me:My@a:", "ftp://Me:my@a");
        URI.testEqual("ftp://a/b%2b/", "ftp://a/b+/");
        URI.testEqual("ftp://a/b%2b/", "ftp://a/b+/");
        URI.testEqual("ftp://a/b%5E/", "ftp://a/b^/");
        URI.testEqual("ftp://a/b%4C/", "ftp://a/bL/");
        URI.testNotEqual("ftp://a/b/", "ftp://a//b/");
        URI.testNotEqual("ftp://a/b/", "ftp://a/b//");
        URI.testNotEqual("ftp://a/b%4C/", "ftp://a/bl/");
        URI.testNotEqual("ftp://a/b%3f/", "ftp://a/b?/");
        URI.testNotEqual("ftp://a/b%2f/", "ftp://a/b//");
        URI.testNotEqual("ftp://a/b%2fc/", "ftp://a/b/c/");
        URI.testNotEqual("ftp://a/bc/", "ftp://a/b//");
        URI.testNotEqual("ftp://a/bc/", "ftp://a/b/");
        URI.testNotEqual("ftp://a/bc//", "ftp://a/b/");
        URI.testNotEqual("ftp://a/b/", "ftp://a/bc//");
        URI.testNotEqual("ftp://a/b/", "ftp://a/bc/");
        URI.testNotEqual("ftp://a/b//", "ftp://a/bc/");
        URI.testNotEqual("ftp://a/b;fc/", "ftp://a/bf;c/");
        URI.testNotEqual("ftp://a/b%3bfc/", "ftp://a/b;fc/");
        URI.testEqual("ftp://a/b;/;/", "ftp://a/b;/;/");
        URI.testNotEqual("ftp://a/b;/", "ftp://a/b//");
        URI.testNotEqual("ftp://a/b//", "ftp://a/b;/");
        URI.testNotEqual("ftp://a/b/;", "ftp://a/b//");
        URI.testNotEqual("ftp://a/b//", "ftp://a/b/;");
        URI.testNotEqual("ftp://a/b;/", "ftp://a/b;//");
        URI.testNotEqual("ftp://a/b;//", "ftp://a/b;/");
        URI.testEscape("hello\u1212there", "hello%E1%88%92there");
        URI.testEscape("hello\u0232there", "hello%C8%B2there");
        URI.testEscape("hello\uda42\udd42there", "hello%F2%A0%A5%82there");
        URI.testEscape("hello\uda42", "hello%ED%A9%82");
        URI.testEscape("hello\uda42there", "hello%ED%A9%82there");
        URI.testUnescape("hello%F2%A0%A5%82there", "hello\uda42\udd42there");
        URI.testUnescape("hello%F2%A0%A5there", "hello\u00f2\u00a0\u00a5there");
        URI.testUnescape("hello%F2%A0there", "hello\u00f2\u00a0there");
        URI.testUnescape("hello%F2there", "hello\u00f2there");
        URI.testUnescape("hello%F2%A0%A5%82", "hello\uda42\udd42");
        URI.testUnescape("hello%F2%A0%A5", "hello\u00f2\u00a0\u00a5");
        URI.testUnescape("hello%F2%A0", "hello\u00f2\u00a0");
        URI.testUnescape("hello%F2", "hello\u00f2");
        URI.testUnescape("hello%E1%88%92there", "hello\u1212there");
        URI.testUnescape("hello%E1%88there", "hello\u00e1\u0088there");
        URI.testUnescape("hello%E1there", "hello\u00e1there");
        URI.testUnescape("hello%E1%71there", "hello\u00e1qthere");
        URI.testUnescape("hello%E1%88", "hello\u00e1\u0088");
        URI.testUnescape("hello%E1%71", "hello\u00e1q");
        URI.testUnescape("hello%E1", "hello\u00e1");
        URI.testUnescape("hello%C8%B2there", "hello\u0232there");
        URI.testUnescape("hello%C8there", "hello\u00c8there");
        URI.testUnescape("hello%C8%71there", "hello\u00c8qthere");
        URI.testUnescape("hello%C8%71", "hello\u00c8q");
        URI.testUnescape("hello%C8", "hello\u00c8");
        URI.testUnescape("%71there", "qthere");
        URI.testUnescape("%B1there", "\u00b1there");
        System.err.println("*** Tests finished successfuly");
    }

    private static void testParser(URI uRI, String string, String string2) throws Exception {
        if (!new URI(uRI, string).toExternalForm().equals(string2)) {
            throw new Exception("Test failed: " + nl + "  base-URI = <" + uRI + ">" + nl + "  rel-URI  = <" + string + ">" + nl + "  expected   <" + string2 + ">" + nl + "  but got    <" + new URI(uRI, string) + ">");
        }
    }

    private static void testEqual(String string, String string2) throws Exception {
        URI uRI = new URI(string);
        URI uRI2 = new URI(string2);
        if (!uRI.equals(uRI2)) {
            throw new Exception("Test failed: " + nl + "  <" + string + "> != <" + string2 + ">");
        }
        if (uRI.hashCode() != uRI2.hashCode()) {
            throw new Exception("Test failed: " + nl + "  hashCode <" + string + "> != hashCode <" + string2 + ">");
        }
    }

    private static void testNotEqual(String string, String string2) throws Exception {
        URI uRI = new URI(string);
        URI uRI2 = new URI(string2);
        if (uRI.equals(uRI2)) {
            throw new Exception("Test failed: " + nl + "  <" + string + "> == <" + string2 + ">");
        }
    }

    private static void testPE(URI uRI, String string) throws Exception {
        boolean bl = false;
        try {
            new URI(uRI, string);
        }
        catch (ParseException parseException) {
            bl = true;
        }
        if (!bl) {
            throw new Exception("Test failed: " + nl + "  <" + string + "> should be invalid");
        }
    }

    private static void testEscape(String string, String string2) throws Exception {
        String string3 = new String(URI.escape(string.toCharArray(), uricChar, true));
        if (!string3.equals(string2)) {
            throw new Exception("Test failed: " + nl + "  raw-string: " + string + nl + "  escaped:    " + string3 + nl + "  expected:   " + string2);
        }
    }

    private static void testUnescape(String string, String string2) throws Exception {
        if (!URI.unescape(string, null).equals(string2)) {
            throw new Exception("Test failed: " + nl + "  escaped-string: " + string + nl + "  unescaped:      " + URI.unescape(string, null) + nl + "  expected:       " + string2);
        }
    }

    static {
        int n;
        defaultPorts = new Hashtable();
        usesGenericSyntax = new Hashtable();
        usesSemiGenericSyntax = new Hashtable();
        defaultPorts.put("http", new Integer(80));
        defaultPorts.put("shttp", new Integer(80));
        defaultPorts.put("http-ng", new Integer(80));
        defaultPorts.put("coffee", new Integer(80));
        defaultPorts.put("https", new Integer(443));
        defaultPorts.put("ftp", new Integer(21));
        defaultPorts.put("telnet", new Integer(23));
        defaultPorts.put("nntp", new Integer(119));
        defaultPorts.put("news", new Integer(119));
        defaultPorts.put("snews", new Integer(563));
        defaultPorts.put("hnews", new Integer(80));
        defaultPorts.put("smtp", new Integer(25));
        defaultPorts.put("gopher", new Integer(70));
        defaultPorts.put("wais", new Integer(210));
        defaultPorts.put("whois", new Integer(43));
        defaultPorts.put("whois++", new Integer(63));
        defaultPorts.put("rwhois", new Integer(4321));
        defaultPorts.put("imap", new Integer(143));
        defaultPorts.put("pop", new Integer(110));
        defaultPorts.put("prospero", new Integer(1525));
        defaultPorts.put("irc", new Integer(194));
        defaultPorts.put("ldap", new Integer(389));
        defaultPorts.put("nfs", new Integer(2049));
        defaultPorts.put("z39.50r", new Integer(210));
        defaultPorts.put("z39.50s", new Integer(210));
        defaultPorts.put("vemmi", new Integer(575));
        defaultPorts.put("videotex", new Integer(516));
        defaultPorts.put("cmp", new Integer(829));
        defaultPorts.put("ssh", new Integer(22));
        defaultPorts.put("sftp", new Integer(22));
        usesGenericSyntax.put("http", Boolean.TRUE);
        usesGenericSyntax.put("https", Boolean.TRUE);
        usesGenericSyntax.put("shttp", Boolean.TRUE);
        usesGenericSyntax.put("coffee", Boolean.TRUE);
        usesGenericSyntax.put("ftp", Boolean.TRUE);
        usesGenericSyntax.put("file", Boolean.TRUE);
        usesGenericSyntax.put("nntp", Boolean.TRUE);
        usesGenericSyntax.put("news", Boolean.TRUE);
        usesGenericSyntax.put("snews", Boolean.TRUE);
        usesGenericSyntax.put("hnews", Boolean.TRUE);
        usesGenericSyntax.put("imap", Boolean.TRUE);
        usesGenericSyntax.put("wais", Boolean.TRUE);
        usesGenericSyntax.put("nfs", Boolean.TRUE);
        usesGenericSyntax.put("sip", Boolean.TRUE);
        usesGenericSyntax.put("sips", Boolean.TRUE);
        usesGenericSyntax.put("sipt", Boolean.TRUE);
        usesGenericSyntax.put("sipu", Boolean.TRUE);
        usesGenericSyntax.put("ssh", Boolean.TRUE);
        usesGenericSyntax.put("sftp", Boolean.TRUE);
        usesSemiGenericSyntax.put("ldap", Boolean.TRUE);
        usesSemiGenericSyntax.put("irc", Boolean.TRUE);
        usesSemiGenericSyntax.put("gopher", Boolean.TRUE);
        usesSemiGenericSyntax.put("videotex", Boolean.TRUE);
        usesSemiGenericSyntax.put("rwhois", Boolean.TRUE);
        usesSemiGenericSyntax.put("whois++", Boolean.TRUE);
        usesSemiGenericSyntax.put("smtp", Boolean.TRUE);
        usesSemiGenericSyntax.put("telnet", Boolean.TRUE);
        usesSemiGenericSyntax.put("prospero", Boolean.TRUE);
        usesSemiGenericSyntax.put("pop", Boolean.TRUE);
        usesSemiGenericSyntax.put("vemmi", Boolean.TRUE);
        usesSemiGenericSyntax.put("z39.50r", Boolean.TRUE);
        usesSemiGenericSyntax.put("z39.50s", Boolean.TRUE);
        usesSemiGenericSyntax.put("stream", Boolean.TRUE);
        usesSemiGenericSyntax.put("cmp", Boolean.TRUE);
        alphanumChar = new BitSet(128);
        for (n = 48; n <= 57; ++n) {
            alphanumChar.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            alphanumChar.set(n);
        }
        for (n = 97; n <= 122; ++n) {
            alphanumChar.set(n);
        }
        markChar = new BitSet(128);
        markChar.set(45);
        markChar.set(95);
        markChar.set(46);
        markChar.set(33);
        markChar.set(126);
        markChar.set(42);
        markChar.set(39);
        markChar.set(40);
        markChar.set(41);
        reservedChar = new BitSet(128);
        reservedChar.set(59);
        reservedChar.set(47);
        reservedChar.set(63);
        reservedChar.set(58);
        reservedChar.set(64);
        reservedChar.set(38);
        reservedChar.set(61);
        reservedChar.set(43);
        reservedChar.set(36);
        reservedChar.set(44);
        unreservedChar = new BitSet(128);
        unreservedChar.or(alphanumChar);
        unreservedChar.or(markChar);
        uricChar = new BitSet(128);
        uricChar.or(unreservedChar);
        uricChar.or(reservedChar);
        uricChar.set(37);
        pcharChar = new BitSet(128);
        pcharChar.or(unreservedChar);
        pcharChar.set(37);
        pcharChar.set(58);
        pcharChar.set(64);
        pcharChar.set(38);
        pcharChar.set(61);
        pcharChar.set(43);
        pcharChar.set(36);
        pcharChar.set(44);
        userinfoChar = new BitSet(128);
        userinfoChar.or(unreservedChar);
        userinfoChar.set(37);
        userinfoChar.set(59);
        userinfoChar.set(58);
        userinfoChar.set(38);
        userinfoChar.set(61);
        userinfoChar.set(43);
        userinfoChar.set(36);
        userinfoChar.set(44);
        schemeChar = new BitSet(128);
        schemeChar.or(alphanumChar);
        schemeChar.set(43);
        schemeChar.set(45);
        schemeChar.set(46);
        opaqueChar = new BitSet(128);
        opaqueChar.or(uricChar);
        hostChar = new BitSet(128);
        hostChar.or(alphanumChar);
        hostChar.set(45);
        hostChar.set(46);
        reg_nameChar = new BitSet(128);
        reg_nameChar.or(unreservedChar);
        reg_nameChar.set(36);
        reg_nameChar.set(44);
        reg_nameChar.set(59);
        reg_nameChar.set(58);
        reg_nameChar.set(64);
        reg_nameChar.set(38);
        reg_nameChar.set(61);
        reg_nameChar.set(43);
        resvdSchemeChar = new BitSet(128);
        resvdSchemeChar.set(58);
        resvdUIChar = new BitSet(128);
        resvdUIChar.set(64);
        resvdHostChar = new BitSet(128);
        resvdHostChar.set(58);
        resvdHostChar.set(47);
        resvdHostChar.set(63);
        resvdHostChar.set(35);
        resvdPathChar = new BitSet(128);
        resvdPathChar.set(47);
        resvdPathChar.set(59);
        resvdPathChar.set(63);
        resvdPathChar.set(35);
        resvdQueryChar = new BitSet(128);
        resvdQueryChar.set(35);
        escpdPathChar = new BitSet(128);
        escpdPathChar.or(pcharChar);
        escpdPathChar.set(37);
        escpdPathChar.set(47);
        escpdPathChar.set(59);
        escpdQueryChar = new BitSet(128);
        escpdQueryChar.or(uricChar);
        escpdQueryChar.clear(35);
        escpdFragChar = new BitSet(128);
        escpdFragChar.or(uricChar);
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        nl = System.getProperty("line.separator");
    }
}

